const express = require('express');
const usersSignup = require('./routes/signup');
const loginRouter = require('./routes/login');
const forexRouter = require('./routes/forex');
const forgotPasswordRouter = require('./routes/forgotpassword');
const transactionRouter = require('./routes/transaction');
const winston = require('winston');
const cors = require('cors');
const db = require('./db');
const app = express();
require('dotenv').config();

app.use(cors());
try {
  app.use(usersSignup);
  app.use(loginRouter);
  app.use(forexRouter);
  app.use(transactionRouter);
  app.use(forgotPasswordRouter);
  app.listen(process.env.PORT || 3050, '127.0.0.1', () => {
    console.log('Server listening on port 3050');
  });

  // Use the app.use() method to define error-handling middleware
  app.use((err, req, res, next) => {
    // Log the error using the Winston logging library
    winston.error(err.message, err);

    // Return a generic error response to the client
    res.status(500).send('Something went wrong');
  });
} catch (err) {
  // Log any unhandled exceptions using the Winston logging library
  winston.error(err.message, err);
}
